from collections import Counter
from typing import List, Tuple, Optional

def compute_self_consistency(outputs: List[str]) -> Optional[Tuple[str, int]]:
    if not outputs:
        return None

    counter = Counter(outputs)
    most_common_output, frequency = counter.most_common(1)[0]
    return frequency

